<?php
// Test page to diagnose image loading issues
require_once __DIR__ . '/../../includes/driver_bootstrap.php';

$driver_id = get_current_driver_id();
$partner_id = current_driver_partner_id();

require_once __DIR__ . '/../../includes/driver_ui_start.php';
?>

<div class="container py-4">
    <h3>Image Loading Test</h3>

    <div class="alert alert-info">
        <strong>Driver Info:</strong><br>
        ID: <?= $driver_id ?><br>
        Partner ID: <?= $partner_id ?><br>
        Session ID: <?= session_id() ?>
    </div>

    <?php
    // Get a sample document
    $stmt = $conn->prepare("SELECT d.file_path FROM driver_documents d
                           JOIN driver_doc_sets s ON s.id = d.doc_set_id
                           WHERE s.driver_id = ? LIMIT 1");
    $stmt->bind_param('i', $driver_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $doc = $result->fetch_assoc();

    if ($doc):
        $path = $doc['file_path'];
        $url = file_url($path);
    ?>
        <div class="card mb-3">
            <div class="card-header">
                <strong>Test Document</strong>
            </div>
            <div class="card-body">
                <p><strong>DB Path:</strong> <code><?= htmlspecialchars($path) ?></code></p>
                <p><strong>Generated URL:</strong> <code><?= htmlspecialchars($url) ?></code></p>

                <h5 class="mt-3">Test 1: Image Tag</h5>
                <img src="<?= $url ?>" class="img-fluid border" style="max-width: 300px;"
                     onerror="this.parentElement.innerHTML += '<div class=\'alert alert-danger mt-2\'>Failed to load image via img tag</div>'"
                     onload="this.parentElement.innerHTML += '<div class=\'alert alert-success mt-2\'>Successfully loaded via img tag!</div>'">

                <h5 class="mt-4">Test 2: Direct Link</h5>
                <a href="<?= $url ?>" target="_blank" class="btn btn-primary">Open in New Tab</a>

                <h5 class="mt-4">Test 3: Fetch API (JavaScript)</h5>
                <button onclick="testFetch('<?= $url ?>')" class="btn btn-secondary">Test Fetch</button>
                <div id="fetch-result" class="mt-2"></div>
            </div>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">No documents found for this driver.</div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header"><strong>Cookie Information</strong></div>
        <div class="card-body">
            <p>Check browser console (F12) for cookie details</p>
            <pre id="cookie-info"></pre>
        </div>
    </div>
</div>

<script>
// Display cookie info
document.getElementById('cookie-info').textContent =
    'document.cookie: ' + document.cookie + '\n\n' +
    'Cookies:\n' +
    document.cookie.split(';').map(c => '  ' + c.trim()).join('\n');

// Test fetch
function testFetch(url) {
    const result = document.getElementById('fetch-result');
    result.innerHTML = '<div class="spinner-border spinner-border-sm"></div> Testing...';

    fetch(url, {
        method: 'GET',
        credentials: 'same-origin'  // Important: include cookies
    })
    .then(response => {
        if (response.ok) {
            result.innerHTML = '<div class="alert alert-success">✓ Fetch successful! Status: ' + response.status + '</div>';
        } else {
            result.innerHTML = '<div class="alert alert-danger">✗ Fetch failed! Status: ' + response.status + ' ' + response.statusText + '</div>';
        }
    })
    .catch(error => {
        result.innerHTML = '<div class="alert alert-danger">✗ Fetch error: ' + error.message + '</div>';
    });
}

// Log image load events
console.log('=== Image Load Test ===');
console.log('Session ID:', '<?= session_id() ?>');
console.log('Cookies:', document.cookie);
</script>

<?php require_once __DIR__ . '/../../includes/driver_ui_end.php'; ?>
