<?php
// public/driver/kyd_start.php

require_once __DIR__ . '/../../includes/driver_auth.php';
require_driver_login();
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';

$driver_id = current_driver_id();

// 1. Check if KYD is already fully approved
$kc = $conn->prepare("SELECT kyc_completed FROM drivers WHERE id=?");
$kc->bind_param('i', $driver_id);
$kc->execute();
$kyc_completed = (int)($kc->get_result()->fetch_column() ?? 0);

if ($kyc_completed === 1) {
  header('Location: dashboard.php');
  exit;
}

// 2. Check individual mandatory components
$sql = "
SELECT 
    group_key, doc_number, expiry_date,
    (SELECT COUNT(*) FROM driver_documents dd WHERE dd.doc_set_id = ds.id AND dd.side='front') as has_front,
    (SELECT COUNT(*) FROM driver_documents dd WHERE dd.doc_set_id = ds.id AND dd.side='back') as has_back
FROM driver_doc_sets ds
WHERE driver_id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $driver_id);
$stmt->execute();
$res = $stmt->get_result();

$status = [];
while($row = $res->fetch_assoc()) {
    $status[$row['group_key']] = $row;
}

// Logic: Check if satisfied
function check_item($key, $data, $needs_back=true, $needs_details=true) {
    if (!isset($data[$key])) return false;
    $d = $data[$key];
    if ($needs_details && (empty($d['doc_number']) || empty($d['expiry_date']))) return false;
    if ($d['has_front'] < 1) return false;
    if ($needs_back && $d['has_back'] < 1) return false;
    return true;
}

// Removed Selfie from this list
$checklist = [
    'Civil ID'      => check_item('civil_id', $status, true, true),
    'License'       => check_item('license', $status, true, true),
    'Vehicle Reg'   => check_item('vehicle_reg', $status, true, true),
];

$all_ok = !in_array(false, $checklist);

// 3. Auto-complete if everything is ready
if ($all_ok) {
    // Update DB
    $up = $conn->prepare("UPDATE drivers SET kyc_completed = 1 WHERE id = ?");
    $up->bind_param('i', $driver_id);
    $up->execute();
    
    // Update Session
    if(isset($_SESSION['driver'])) $_SESSION['driver']['kyc_completed'] = 1;

    // Refresh to trigger redirect
    header("Location: dashboard.php");
    exit;
}

$title = 'Setup Account';
require_once __DIR__ . '/../../includes/driver_ui_start.php';
?>

<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card shadow-sm text-center mb-4">
            <div class="card-body py-5">
                <div class="mb-4">
                    <div class="bg-danger text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <i class="bi bi-shield-lock fs-3"></i>
                    </div>
                </div>
                <h3 class="fw-bold">Account Verification</h3>
                <p class="text-muted">To activate your driver account, we need to verify your identity and vehicle documents.</p>
                
                <div class="d-grid gap-2 col-md-8 mx-auto mt-4">
                    <a href="kyd_manage.php" class="btn btn-danger btn-lg shadow-sm">
                        Upload Documents
                    </a>
                </div>
            </div>
        </div>

        <div class="card shadow-sm">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0 fw-bold">Required Checklist</h6>
            </div>
            <ul class="list-group list-group-flush">
                <?php foreach($checklist as $name => $is_done): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <span class="<?= $is_done ? 'text-decoration-line-through text-muted' : '' ?>">
                        <?= $name ?>
                    </span>
                    <?php if($is_done): ?>
                        <i class="bi bi-check-circle-fill text-success"></i>
                    <?php else: ?>
                        <i class="bi bi-circle text-muted"></i>
                    <?php endif; ?>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/driver_ui_end.php'; ?>