// File: public/driver/driver-sw.js

const DRIVER_SW_VERSION = 'hisbuu-driver-v1';
const DRIVER_SW_CACHE = 'hisbuu-driver-cache-' + DRIVER_SW_VERSION;
const OFFLINE_URL = '/public/driver/offline.html';

self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(DRIVER_SW_CACHE).then(cache => {
      return cache.addAll([
        OFFLINE_URL,
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css'
      ]);
    })
  );
  self.skipWaiting();
});

self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(keys => {
      return Promise.all(
        keys
          .filter(k => k.startsWith('hisbuu-driver-cache-') && k !== DRIVER_SW_CACHE)
          .map(k => caches.delete(k))
      );
    })
  );
  self.clients.claim();
});

// Strict offline lock for navigation
self.addEventListener('fetch', event => {
  const req = event.request;

  // Only care about navigation requests (full page loads)
  if (req.mode === 'navigate') {
    event.respondWith(
      fetch(req).catch(() => {
        return caches.match(OFFLINE_URL);
      })
    );
    return;
  }

  // For all other requests, let the network handle it
  // No extra caching for API or pages
});
