<?php
// public/driver/fix_constraints.php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../../config/db.php';

echo "<h2>Database Constraint Repair</h2><pre>";

// 1. Drop the bad constraint (The one causing the crash)
try {
    echo "Attempting to drop bad constraint 'uq_set' (Unique Number)... ";
    $conn->query("ALTER TABLE driver_doc_sets DROP INDEX uq_set");
    echo "<span style='color:green'>SUCCESS: Bad rule removed.</span>\n";
} catch (Exception $e) {
    echo "Info: " . $e->getMessage() . " (Might already be gone)\n";
}

// 2. Add the correct constraint (Unique Group Key)
try {
    echo "Adding correct constraint 'uq_driver_group' (Unique Type)... ";
    $conn->query("ALTER TABLE driver_doc_sets ADD UNIQUE KEY uq_driver_group (driver_id, group_key)");
    echo "<span style='color:green'>SUCCESS: Correct rule added.</span>\n";
} catch (Exception $e) {
    echo "Info: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<h3><a href='kyd_manage.php'>Repair Complete. Try Uploading Selfie Now.</a></h3>";
?>