<?php
// Save as /hisbuu/public/dev/set_driver_password.php
// Usage (POST): uuid=F/A-0001, password=demo123
require_once __DIR__ . '/../../config/db.php';
header('Content-Type: text/html; charset=utf-8');

function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $uuid = trim($_POST['uuid'] ?? '');
  $plain = (string)($_POST['password'] ?? '');
  if ($uuid === '' || $plain === '') {
    echo '<div style="color:red">UUID and password are required.</div>';
  } else {
    $hash = password_hash($plain, PASSWORD_BCRYPT);
    if ($hash === false) {
      echo '<div style="color:red">Failed to hash password, check PHP password_* functions.</div>';
    } else {
      $stmt = $conn->prepare('UPDATE drivers SET login_password=? WHERE partner_id=?');
      $stmt->bind_param('ss', $hash, $uuid);
      $stmt->execute();
      echo '<div style="color:green">Updated. New hash length: '.strlen($hash).'</div>';
      echo '<pre>UUID: '.e($uuid).'\nHash: '.e($hash).'</pre>';
    }
  }
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>Set driver password</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="p-4">
  <h5>Set driver password</h5>
  <form method="POST" class="row g-3" style="max-width:500px">
    <div class="col-12">
      <label class="form-label">UUID (partner_id)</label>
      <input class="form-control" name="uuid" placeholder="F/A-0001" required>
    </div>
    <div class="col-12">
      <label class="form-label">New password</label>
      <input class="form-control" type="text" name="password" placeholder="demo123" required>
    </div>
    <div class="col-12 text-end">
      <button class="btn btn-primary">Set password</button>
    </div>
  </form>
  <hr>
  <p>After updating, test login or use <a href="check_driver.php">check_driver.php</a>.</p>
</body></html>