<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';

$role = get_current_role();
$can_manage = can_manage_lookups($role);
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

$ok = ''; $err = '';

// Ensure tables (safe if exist)
$conn->query("CREATE TABLE IF NOT EXISTS cities (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$conn->query("CREATE TABLE IF NOT EXISTS zones (
  id INT AUTO_INCREMENT PRIMARY KEY,
  city_id INT NOT NULL,
  name VARCHAR(120) NOT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL,
  INDEX idx_zones_city_id (city_id),
  CONSTRAINT fk_zones_city FOREIGN KEY (city_id) REFERENCES cities(id)
    ON UPDATE CASCADE ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Ensure unique constraint only once
$chk = $conn->query("SHOW INDEX FROM zones WHERE Key_name='uk_city_zone'");
if ($chk->num_rows === 0) {
    $conn->query("ALTER TABLE zones ADD UNIQUE KEY uk_city_zone (city_id, name)");
}


// Cities list
$cities = [];
$res = $conn->query("SELECT id,name FROM cities WHERE is_active=1 ORDER BY name");
while ($r = $res->fetch_assoc()) $cities[] = $r;

// Filters
$city_filter = isset($_GET['city']) && ctype_digit($_GET['city']) ? (int)$_GET['city'] : 0;

// Create / Update
if ($can_manage && $_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $zid   = isset($_POST['id']) && ctype_digit($_POST['id']) ? (int)$_POST['id'] : 0;
  $name  = trim($_POST['name'] ?? '');
  $city  = isset($_POST['city_id']) && ctype_digit($_POST['city_id']) ? (int)$_POST['city_id'] : 0;
  $act   = isset($_POST['is_active']) ? 1 : 0;

  if ($name==='' || $city<=0) {
    $err = 'City and zone name are required.';
  } else {
    if ($zid > 0) {
      $st = $conn->prepare("UPDATE zones SET city_id=?, name=?, is_active=?, updated_at=NOW() WHERE id=?");
      $st->bind_param('isii', $city, $name, $act, $zid);
      $ok = $st->execute() ? 'Zone updated.' : 'Update failed.';
    } else {
      $st = $conn->prepare("INSERT INTO zones (city_id, name, is_active) VALUES (?,?,?)");
      $st->bind_param('isi', $city, $name, $act);
      $ok = $st->execute() ? 'Zone created.' : 'Create failed. Likely duplicate in this city.';
    }
  }
}

// Delete
if ($can_manage && isset($_GET['del'], $_GET['csrf']) && hash_equals($csrf, $_GET['csrf'])) {
  $del = ctype_digit($_GET['del']) ? (int)$_GET['del'] : 0;
  if ($del > 0) {
    $st = $conn->prepare("DELETE FROM zones WHERE id=?");
    $st->bind_param('i', $del);
    $ok = $st->execute() ? 'Zone deleted.' : 'Delete failed. In use?';
  }
}

// Edit target
$edit = null;
if ($can_manage && isset($_GET['id']) && ctype_digit($_GET['id'])) {
  $eid = (int)$_GET['id'];
  $st = $conn->prepare("SELECT id, city_id, name, is_active FROM zones WHERE id=?");
  $st->bind_param('i', $eid);
  $st->execute();
  $edit = $st->get_result()->fetch_assoc() ?: null;
}

// List data
$where = $city_filter ? "WHERE z.city_id=".$city_filter : "";
$q = $conn->query("
  SELECT z.id, z.name, z.is_active, z.created_at, c.name AS city_name, z.city_id
  FROM zones z
  JOIN cities c ON c.id=z.city_id
  $where
  ORDER BY c.name, z.name
");
$rows = [];
while ($r = $q->fetch_assoc()) $rows[] = $r;

// Current city label
$currentCityName = 'All cities';
if ($city_filter) {
  foreach ($cities as $c) if ((int)$c['id']===$city_filter) { $currentCityName = $c['name']; break; }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Zones | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Zones</h5>
    <form class="d-flex gap-2" method="get">
      <select class="form-select form-select-sm" name="city">
        <option value="0">All cities</option>
        <?php foreach($cities as $c): ?>
          <option value="<?php echo (int)$c['id']; ?>" <?php echo $city_filter===(int)$c['id']?'selected':''; ?>>
            <?php echo e($c['name']); ?>
          </option>
        <?php endforeach; ?>
      </select>
      <button class="btn btn-outline-secondary btn-sm">Filter</button>
    </form>
  </div>

  <?php if($ok): ?><div class="alert alert-success py-2"><?php echo e($ok); ?></div><?php endif; ?>
  <?php if($err): ?><div class="alert alert-danger py-2"><?php echo e($err); ?></div><?php endif; ?>

  <div class="row g-3">
    <?php if ($can_manage): ?>
      <div class="col-md-4">
        <div class="card shadow-sm">
          <div class="card-body">
            <h6 class="mb-3"><?php echo $edit ? 'Edit zone' : 'Add zone'; ?></h6>
            <form method="post">
              <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
              <?php if ($edit): ?>
                <input type="hidden" name="id" value="<?php echo (int)$edit['id']; ?>">
              <?php endif; ?>
              <div class="mb-2">
                <label class="form-label">City</label>
                <select name="city_id" class="form-select" required>
                  <option value="">Select</option>
                  <?php foreach($cities as $c): ?>
                    <option value="<?php echo (int)$c['id']; ?>" <?php
                      $sel = $edit ? (int)$edit['city_id'] : ($city_filter ?: 0);
                      echo $sel===(int)$c['id']?'selected':'';
                    ?>>
                      <?php echo e($c['name']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label">Zone name</label>
                <input class="form-control" name="name" value="<?php echo e($edit['name'] ?? ''); ?>" required>
              </div>
              <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="is_active" id="act" <?php echo (!isset($edit) || (int)($edit['is_active'] ?? 1)===1)?'checked':''; ?>>
                <label class="form-check-label" for="act">Active</label>
              </div>
              <div class="text-end">
                <button class="btn btn-danger"><?php echo $edit ? 'Save changes' : 'Create zone'; ?></button>
              </div>
            </form>
          </div>
        </div>
      </div>
    <?php else: ?>
      <div class="col-md-4">
        <div class="alert alert-secondary mb-0">View only. Supervisors cannot add or edit zones.</div>
      </div>
    <?php endif; ?>

    <div class="col-md-8">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="fw-semibold mb-2">
            All zones <?php echo $city_filter ? '(' . e($currentCityName) . ')' : ''; ?>
          </div>
          <div class="table-responsive">
            <table class="table table-striped align-middle">
              <thead class="table-danger">
                <tr>
                  <th>City</th>
                  <th>Zone</th>
                  <th>Status</th>
                  <th>Created</th>
                  <th class="text-end">Action</th>
                </tr>
              </thead>
              <tbody>
                <?php if (!$rows): ?>
                  <tr><td colspan="5" class="text-center text-muted">No zones</td></tr>
                <?php else: foreach($rows as $r): ?>
                  <tr>
                    <td><?php echo e($r['city_name']); ?></td>
                    <td><?php echo e($r['name']); ?></td>
                    <td><?php echo (int)$r['is_active']===1 ? '<span class="badge text-bg-success">Active</span>' : '<span class="badge text-bg-secondary">Inactive</span>'; ?></td>
                    <td><span class="text-muted"><?php echo e($r['created_at']); ?></span></td>
                    <td class="text-end">
                      <?php if ($can_manage): ?>
                        <a href="zones_manage.php?id=<?php echo (int)$r['id']; ?>&city=<?php echo (int)$r['city_id']; ?>" class="btn btn-outline-primary btn-sm">Edit</a>
                        <a href="zones_manage.php?del=<?php echo (int)$r['id']; ?>&csrf=<?php echo e($csrf); ?>&city=<?php echo (int)$city_filter; ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete this zone?');">Delete</a>
                      <?php else: ?>
                        <span class="text-muted">No actions</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
