<?php
// public/admin/users_reset.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_users(get_current_role())) { http_response_code(403); exit('Forbidden'); }

$err = $_GET['err'] ?? '';
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { http_response_code(400); exit('Bad request'); }
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Reset Password</title>
</head>
<body class="bg-light">
<?php @include __DIR__ . '/../../includes/admin_nav.php'; ?>
<div class="container py-4" style="max-width:640px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Reset password</h5>
    <a class="btn btn-outline-secondary btn-sm" href="users_manage.php">Back</a>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>

  <div class="card"><div class="card-body">
    <form method="POST" action="users_reset_store.php">
      <input type="hidden" name="id" value="<?php echo (int)$id; ?>">
      <div class="mb-3">
        <label class="form-label">New temporary password</label>
        <input type="text" class="form-control" name="password" required>
        <div class="form-text">The user should change it after login.</div>
      </div>
      <div class="text-end">
        <button class="btn btn-danger">Set password</button>
      </div>
    </form>
  </div></div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
