<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';

$role = get_current_role();
$can_manage = can_manage_lookups($role);
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

$ok=''; $err='';

// Ensure table (generic lookup)
$conn->query("CREATE TABLE IF NOT EXISTS types (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL UNIQUE,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Save
if ($can_manage && $_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $tid   = isset($_POST['id']) && ctype_digit($_POST['id']) ? (int)$_POST['id'] : 0;
  $name  = trim($_POST['name'] ?? '');
  $act   = isset($_POST['is_active']) ? 1 : 0;

  if ($name==='') {
    $err = 'Name is required.';
  } else {
    if ($tid > 0) {
      $st = $conn->prepare("UPDATE types SET name=?, is_active=?, updated_at=NOW() WHERE id=?");
      $st->bind_param('sii', $name, $act, $tid);
      $ok = $st->execute() ? 'Type updated.' : 'Update failed.';
    } else {
      $st = $conn->prepare("INSERT INTO types (name, is_active) VALUES (?,?)");
      $st->bind_param('si', $name, $act);
      $ok = $st->execute() ? 'Type created.' : 'Create failed. Duplicate?';
    }
  }
}

// Delete
if ($can_manage && isset($_GET['del'], $_GET['csrf']) && hash_equals($csrf, $_GET['csrf'])) {
  $del = ctype_digit($_GET['del']) ? (int)$_GET['del'] : 0;
  if ($del > 0) {
    $st = $conn->prepare("DELETE FROM types WHERE id=?");
    $st->bind_param('i', $del);
    $ok = $st->execute() ? 'Type deleted.' : 'Delete failed. In use?';
  }
}

// Edit
$edit=null;
if ($can_manage && isset($_GET['id']) && ctype_digit($_GET['id'])) {
  $eid=(int)$_GET['id'];
  $st=$conn->prepare("SELECT id,name,is_active FROM types WHERE id=?");
  $st->bind_param('i', $eid);
  $st->execute();
  $edit=$st->get_result()->fetch_assoc() ?: null;
}

// List
$rows=[];
$q=$conn->query("SELECT id,name,is_active,created_at FROM types ORDER BY name");
while($r=$q->fetch_assoc()) $rows[]=$r;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Types | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Types</h5>
  </div>

  <?php if($ok): ?><div class="alert alert-success py-2"><?php echo e($ok); ?></div><?php endif; ?>
  <?php if($err): ?><div class="alert alert-danger py-2"><?php echo e($err); ?></div><?php endif; ?>

  <div class="row g-3">
    <?php if ($can_manage): ?>
      <div class="col-md-4">
        <div class="card shadow-sm">
          <div class="card-body">
            <h6 class="mb-3"><?php echo $edit ? 'Edit type' : 'Add type'; ?></h6>
            <form method="post">
              <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
              <?php if ($edit): ?>
                <input type="hidden" name="id" value="<?php echo (int)$edit['id']; ?>">
              <?php endif; ?>
              <div class="mb-2">
                <label class="form-label">Name</label>
                <input class="form-control" name="name" value="<?php echo e($edit['name'] ?? ''); ?>" required>
              </div>
              <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="is_active" id="act" <?php echo (!isset($edit) || (int)($edit['is_active'] ?? 1)===1)?'checked':''; ?>>
                <label class="form-check-label" for="act">Active</label>
              </div>
              <div class="text-end">
                <button class="btn btn-danger"><?php echo $edit ? 'Save changes' : 'Create type'; ?></button>
              </div>
            </form>
          </div>
        </div>
      </div>
    <?php else: ?>
      <div class="col-md-4">
        <div class="alert alert-secondary mb-0">View only. Supervisors cannot add or edit types.</div>
      </div>
    <?php endif; ?>

    <div class="col-md-8">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-striped align-middle">
              <thead class="table-danger">
                <tr>
                  <th>Name</th>
                  <th>Status</th>
                  <th>Created</th>
                  <th class="text-end">Action</th>
                </tr>
              </thead>
              <tbody>
                <?php if(!$rows): ?>
                  <tr><td colspan="4" class="text-center text-muted">No types</td></tr>
                <?php else: foreach($rows as $r): ?>
                  <tr>
                    <td><?php echo e($r['name']); ?></td>
                    <td><?php echo (int)$r['is_active']===1 ? '<span class="badge text-bg-success">Active</span>' : '<span class="badge text-bg-secondary">Inactive</span>'; ?></td>
                    <td><span class="text-muted"><?php echo e($r['created_at']); ?></span></td>
                    <td class="text-end">
                      <?php if ($can_manage): ?>
                        <a href="types_manage.php?id=<?php echo (int)$r['id']; ?>" class="btn btn-outline-primary btn-sm">Edit</a>
                        <a href="types_manage.php?del=<?php echo (int)$r['id']; ?>&csrf=<?php echo e($csrf); ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete this type?');">Delete</a>
                      <?php else: ?>
                        <span class="text-muted">No actions</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
