<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
$role = get_current_role();
$can_view = (
  can_manage_finance($role) ||
  can_review_submissions($role) ||
  can_approve_submissions($role) ||
  in_array($role, ['Administrator','Super Administrator','Supervisor'], true)
);
if (!$can_view) { http_response_code(403); exit('Forbidden'); }

$month = $_GET['month'] ?? date('Y-m');
if (!is_string($month) || !preg_match('/^\d{4}-\d{2}$/', $month)) $month = date('Y-m');

$status = isset($_GET['status']) && in_array($_GET['status'], ['approved','pending','rejected','all'], true)
  ? $_GET['status']
  : 'approved';
$q = trim($_GET['q'] ?? '');
list($y,$m) = explode('-', $month);
$start = "$y-$m-01"; $end = date('Y-m-d', strtotime("$start +1 month"));
$where = 's.service_date >= ? AND s.service_date < ?';
$params = [$start,$end]; $types='ss';
if ($status !== 'all') { $where .= ' AND s.status=?'; $params[]=$status; $types.='s'; }
if ($q!=='') { $where .= " AND (CONCAT(COALESCE(d.first_name,''),' ',COALESCE(d.last_name,'')) LIKE ? OR d.partner_id LIKE ?)"; $like = "%$q%"; $params[]=$like; $params[]=$like; $types.='ss'; }
$sql = "SELECT d.id driver_id, CONCAT(COALESCE(d.first_name,''),' ',COALESCE(d.last_name,'')) driver_name, d.partner_id,
               SUM(s.orders_count) total_orders, SUM(s.cash_deposited) total_cash
        FROM submissions s JOIN drivers d ON d.id=s.driver_id
        WHERE $where GROUP BY d.id, driver_name, d.partner_id ORDER BY driver_name";
$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute(); $rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$PAGE_TITLE = 'Submissions summary';
require_once __DIR__ . '/../../includes/admin_header.php';
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Submissions summary</h5>
    <a class="btn btn-outline-secondary btn-sm" href="<?php echo base_url('admin/submissions_list.php'); ?>">Back</a>
  </div>
  <form class="row gy-2 gx-3 align-items-end mb-3" method="GET">
    <div class="col-auto"><label class="form-label">Month</label><input class="form-control" type="month" name="month" value="<?php echo e($month); ?>"></div>
    <div class="col-auto"><label class="form-label">Status</label>
      <select class="form-select" name="status">
        <?php foreach (['approved'=>'Approved','pending'=>'Pending','rejected'=>'Rejected','all'=>'All'] as $val=>$label): ?>
          <option value="<?php echo $val; ?>" <?php echo $status===$val?'selected':''; ?>><?php echo $label; ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto"><label class="form-label">Search</label><input class="form-control" type="text" name="q" placeholder="Name or UUID" value="<?php echo e($q); ?>"></div>
    <div class="col-auto"><button class="btn btn-primary">Apply</button></div>
  </form>
  <div class="card"><div class="card-body p-0">
    <table class="table table-striped mb-0">
      <thead><tr><th>Driver</th><th>UUID</th><th class="text-end">Orders</th><th class="text-end">Cash</th></tr></thead>
      <tbody>
        <?php $sumO=0;$sumC=0.0; foreach ($rows as $r): $sumO+=(int)$r['total_orders']; $sumC+=(float)$r['total_cash']; ?>
        <tr>
          <td><?php echo e($r['driver_name']); ?></td>
          <td><?php echo e($r['partner_id']); ?></td>
          <td class="text-end"><?php echo (int)$r['total_orders']; ?></td>
          <td class="text-end"><?php echo number_format((float)$r['total_cash'],3); ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot><tr><th colspan="2" class="text-end">Totals</th><th class="text-end"><?php echo (int)$sumO; ?></th><th class="text-end"><?php echo number_format($sumC,3); ?></th></tr></tfoot>
    </table>
  </div></div>
<?php require_once __DIR__ . '/../../includes/admin_footer.php'; ?>
