<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_review_submissions(get_current_role())) { http_response_code(403); exit('Forbidden'); }
$q = $conn->query('SELECT s.*, d.first_name, d.last_name, d.partner_id FROM submissions s JOIN drivers d ON d.id=s.driver_id WHERE s.status="pending" ORDER BY s.service_date DESC');
$rows = $q->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<title>Pending approvals - Hisbuu</title></head>
<body class="bg-light"><div class="container py-4">
  <div class="d-flex justify-content-between mb-3">
    <h5>Pending approvals</h5>
    <a href="<?php echo base_url('dashboard.php'); ?>" class="btn btn-outline-secondary btn-sm">Back</a>
  </div>
  <div class="card"><div class="card-body p-0">
    <table class="table mb-0">
      <thead><tr><th>Date</th><th>Driver</th><th>UUID</th><th>Orders</th><th>Cash</th><th>Screenshots</th><th></th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?php echo e($r['service_date']); ?></td>
          <td><?php echo e(trim(($r['first_name']??'').' '.($r['last_name']??''))); ?></td>
          <td><?php echo e($r['partner_id']); ?></td>
          <td><?php echo (int)$r['orders_count']; ?></td>
          <td><?php echo number_format((float)$r['cash_deposited'],2); ?></td>
          <td>
            <a target="_blank" href="<?php echo base_url('admin/preview.php?id='.(int)$r['id'].'&slot=ss_orders'); ?>">Orders</a>
            <?php if ($r['ss_deposit_1']): ?> | <a target="_blank" href="<?php echo base_url('admin/preview.php?id='.(int)$r['id'].'&slot=ss_deposit_1'); ?>">Slip 1</a><?php endif; ?>
            <?php if ($r['ss_deposit_2']): ?> | <a target="_blank" href="<?php echo base_url('admin/preview.php?id='.(int)$r['id'].'&slot=ss_deposit_2'); ?>">Slip 2</a><?php endif; ?>
          </td>
          <td class="text-end">
            <form class="d-inline" method="POST" action="submission_action.php">
              <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
              <input type="hidden" name="action" value="approve">
              <button class="btn btn-success btn-sm">Approve</button>
            </form>
            <form class="d-inline" method="POST" action="submission_action.php">
              <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
              <input type="hidden" name="action" value="reject">
              <button class="btn btn-outline-danger btn-sm">Reject</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div></div>
</div></body></html>
