<?php
// public/admin/reconcile_list.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
$role = strtolower(get_current_role() ?? '');
if (!in_array($role, ['super administrator','administrator','finance administrator','supervisor'], true)) {
  http_response_code(403); exit('Forbidden');
}

if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

// -------- Filters (kept same semantics) --------
$status  = $_GET['status'] ?? 'all';
$driverq = trim($_GET['driver'] ?? '');
$from    = trim($_GET['from'] ?? '');
$to      = trim($_GET['to'] ?? '');

$where=[]; $types=''; $params=[];
if ($status!=='all') { $where[]="s.status=?"; $types.='s'; $params[]=$status; }
if ($driverq!=='') {
  $where[]="(d.partner_id LIKE CONCAT('%',?,'%') OR CONCAT(d.first_name,' ',d.last_name) LIKE CONCAT('%',?,'%'))";
  $types.='ss'; $params[]=$driverq; $params[]=$driverq;
}
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$from)) { $where[]="s.service_date>=?"; $types.='s'; $params[]=$from; }
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$to))   { $where[]="s.service_date<=?"; $types.='s'; $params[]=$to; }
$wsql = $where ? 'WHERE '.implode(' AND ',$where) : '';

// -------- Query (unchanged fields) --------
$sql = "
SELECT
  s.id, s.driver_id, s.service_date, s.orders_count, s.cash_deposited, s.trx_no,
  s.ss_orders, s.ss_deposit_1, s.ss_deposit_2, s.remarks, s.status, s.created_at,
  d.partner_id, CONCAT(d.first_name,' ',d.last_name) AS driver_name
FROM submissions s
JOIN drivers d ON d.id=s.driver_id
$wsql
ORDER BY s.service_date DESC, s.created_at DESC
LIMIT 500
";
$stmt = $conn->prepare($sql);
if ($types!=='') $stmt->bind_param($types, ...$params);
$stmt->execute();
$res  = $stmt->get_result();
$rows = $res->fetch_all(MYSQLI_ASSOC);

// -------- CSV Export (kept as before) --------
if (isset($_GET['export']) && $_GET['export']==='csv') {
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="submissions.csv"');
  $out=fopen('php://output','w');
  fputcsv($out, ['date','driver id','driver name','orders','cash amount','bank trx no','submission timestamp','remarks','status']);
  foreach($rows as $r){
    fputcsv($out, [
      $r['service_date'],
      $r['partner_id'],
      $r['driver_name'],
      (int)$r['orders_count'],
      number_format((float)$r['cash_deposited'], 3, '.', ''),
      (string)($r['trx_no'] ?? ''),
      $r['created_at'],
      (string)($r['remarks'] ?? ''),
      $r['status'],
    ]);
  }
  fclose($out); exit;
}

// -------- Local helper only for preview (no UI change) --------
function _sl_preview($path){
  if (!$path) return '<div class="text-muted">No file</div>';
  $url = file_url($path);
  $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH) ?? '', PATHINFO_EXTENSION));
  if (in_array($ext, ['jpg','jpeg','png','gif','webp'])) {
    return '<img src="'.e($url).'" class="img-fluid rounded border" alt="preview">';
  }
  if ($ext==='pdf') {
    return '<div class="ratio ratio-4x3"><iframe src="'.e($url).'" class="rounded border" title="PDF"></iframe></div>';
  }
  return '<a class="btn btn-outline-secondary" href="'.e($url).'" target="_blank">Open file</a>';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Submissions | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .nowrap{white-space:nowrap}
  </style>
</head>
<body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Submissions</h5>
    <div>
      <a class="btn btn-outline-secondary btn-sm" href="?<?php $q=$_GET; $q['export']='csv'; echo e(http_build_query($q)); ?>">Export CSV</a>
    </div>
  </div>

  <form class="row g-2 mb-3" method="get">
    <div class="col-md-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <?php foreach(['all'=>'All','pending'=>'Pending','approved'=>'Approved','rejected'=>'Rejected'] as $v=>$l): ?>
          <option value="<?php echo e($v); ?>" <?php echo $status===$v?'selected':''; ?>><?php echo e($l); ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Driver</label>
      <input name="driver" class="form-control" placeholder="UUID or name" value="<?php echo e($driverq); ?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">From</label>
      <input type="date" name="from" class="form-control" value="<?php echo e($from); ?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">To</label>
      <input type="date" name="to" class="form-control" value="<?php echo e($to); ?>">
    </div>
    <div class="col-md-2 d-flex align-items-end">
      <button class="btn btn-danger w-100">Filter</button>
    </div>
  </form>

  <div class="card">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-striped align-middle mb-0">
          <thead class="table-danger">
            <tr>
              <th>Driver</th>
              <th class="nowrap">Date</th>
              <th>Orders</th>
              <th>Amount</th>
              <th>TRX</th>
              <th>Attachment</th>
              <th>Status</th>
              <th>Submitted</th>
            </tr>
          </thead>
          <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="8" class="text-center text-muted py-4">No submissions found</td></tr>
          <?php else: foreach($rows as $r): $sid=(int)$r['id']; ?>
            <?php
              $ordersUrl = file_url($r['ss_orders'] ?? '');
              $dep1Url   = file_url($r['ss_deposit_1'] ?? '');
              $dep2Url   = file_url($r['ss_deposit_2'] ?? '');
            ?>
            <tr>
              <td>
                <strong><?php echo e($r['partner_id']); ?></strong><br>
                <small class="text-muted"><?php echo e($r['driver_name']); ?></small>
              </td>
              <td class="nowrap"><?php echo e($r['service_date']); ?></td>
              <td><?php echo (int)$r['orders_count']; ?></td>
              <td><?php echo number_format((float)$r['cash_deposited'], 3, '.', ''); ?></td>
              <td><?php echo e($r['trx_no'] ?: '-'); ?></td>

              <!-- Attachment column: only fix is working modals -->
              <td class="nowrap">
                <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#mOrders_<?php echo $sid; ?>">Orders</button>
                <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#mDep1_<?php echo $sid; ?>">Dep 1</button>
                <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#mDep2_<?php echo $sid; ?>">Dep 2</button>
              </td>

              <td>
                <?php
                  $s=strtolower($r['status']);
                  if ($s==='approved') echo '<span class="badge text-bg-success">Approved</span>';
                  elseif ($s==='rejected') echo '<span class="badge text-bg-danger">Rejected</span>';
                  else echo '<span class="badge text-bg-warning text-dark">Pending</span>';
                ?>
              </td>
              <td class="nowrap"><?php echo e($r['created_at']); ?></td>
            </tr>

            <!-- Orders modal -->
            <div class="modal fade" id="mOrders_<?php echo $sid; ?>" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content">
                <div class="modal-header">
                  <h6 class="modal-title">Order screenshot · <?php echo e($r['service_date']); ?></h6>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <?php echo _sl_preview($r['ss_orders'] ?? null); ?>
                </div>
              </div></div>
            </div>

            <!-- Deposit 1 modal -->
            <div class="modal fade" id="mDep1_<?php echo $sid; ?>" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content">
                <div class="modal-header">
                  <h6 class="modal-title">Deposit slip 1 · <?php echo e($r['service_date']); ?></h6>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <?php echo _sl_preview($r['ss_deposit_1'] ?? null); ?>
                </div>
              </div></div>
            </div>

            <!-- Deposit 2 modal -->
            <div class="modal fade" id="mDep2_<?php echo $sid; ?>" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content">
                <div class="modal-header">
                  <h6 class="modal-title">Deposit slip 2 · <?php echo e($r['service_date']); ?></h6>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <?php echo _sl_preview($r['ss_deposit_2'] ?? null); ?>
                </div>
              </div></div>
            </div>

          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS bundle required for modals -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
