<?php
require_once __DIR__ . '/../../../includes/admin_bootstrap.php';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_cycle'])) {
    $cycle_month = trim($_POST['cycle_month'] ?? '');
    if (!preg_match('/^\d{4}-\d{2}$/', $cycle_month)) {
        $errors[] = 'Invalid month format. Use YYYY-MM.';
    } else {
        $period_start = $cycle_month . '-01';
        $period_end   = date('Y-m-t', strtotime($period_start));

        $stmt = $conn->prepare("SELECT id FROM payout_cycles WHERE cycle_month=? LIMIT 1");
        $stmt->bind_param('s', $cycle_month);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $errors[] = 'This cycle already exists.';
        } else {
            $stmt->close();
            $stmt = $conn->prepare("
                INSERT INTO payout_cycles(cycle_month, period_start, period_end, status, created_by, created_at)
                VALUES (?,?,?,'draft',?,NOW())
            ");
            $uid = (int)$_SESSION['user']['id'];
            $stmt->bind_param('sssi', $cycle_month, $period_start, $period_end, $uid);
            $stmt->execute();
            $new_id = $stmt->insert_id;
            header('Location: payout_cycle_view.php?id=' . $new_id);
            exit;
        }
        $stmt->close();
    }
}

$sql = "
    SELECT pc.*, u.email AS created_by_email
    FROM payout_cycles pc
    LEFT JOIN users u ON u.id = pc.created_by
    ORDER BY pc.period_start DESC, pc.id DESC
";
$cycles = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Payout Cycles | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include __DIR__ . '/../../../includes/admin_nav.php'; ?>

<div class="container py-3">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Payout Cycles</h5>
    <div></div>
  </div>

  <?php if ($errors): ?>
    <div class="alert alert-danger py-2">
      <?php foreach ($errors as $e) echo e($e) . '<br>'; ?>
    </div>
  <?php endif; ?>

  <div class="card mb-3">
    <div class="card-body">
      <form method="post" class="row g-2">
        <?php echo csrf_input(); ?>
    <div class="col-md-3">
    <label class="form-label">Month (YYYY-MM)</label>
    <input type="text" name="cycle_month" class="form-control" placeholder="<?php echo date('Y-m'); ?>" required>
  </div>
  <div class="col-md-3 d-flex align-items-end">
    <button class="btn btn-danger" name="create_cycle">Create Cycle</button>
  </div>
</form>

    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-striped align-middle">
          <thead class="table-danger">
          <tr>
            <th>ID</th>
            <th>Month</th>
            <th>Period</th>
            <th>Status</th>
            <th>Created by</th>
            <th>Created</th>
            <th>Locked</th>
            <th>Paid</th>
            <th></th>
          </tr>
          </thead>
          <tbody>
          <?php if (!$cycles): ?>
            <tr><td colspan="9" class="text-center text-muted">No cycles found</td></tr>
          <?php else: foreach ($cycles as $c): ?>
            <?php
            $badge = 'secondary';
            if ($c['status']==='locked') $badge='warning';
            if ($c['status']==='paid') $badge='success';
            ?>
            <tr>
              <td><?php echo $c['id']; ?></td>
              <td><?php echo e($c['cycle_month']); ?></td>
              <td><?php echo e($c['period_start']); ?> → <?php echo e($c['period_end']); ?></td>
              <td><span class="badge text-bg-<?php echo $badge; ?>"><?php echo e($c['status']); ?></span></td>
              <td><?php echo e($c['created_by_email']); ?></td>
              <td><?php echo e($c['created_at']); ?></td>
              <td><?php echo e($c['locked_at']); ?></td>
              <td><?php echo e($c['paid_at']); ?></td>
              <td>
                <a href="payout_cycle_view.php?id=<?php echo $c['id']; ?>" class="btn btn-sm btn-outline-primary">Open</a>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>

</body>
</html>
