<?php
// public/admin/partner_template.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_partner_daily(get_current_role())) { http_response_code(403); exit('Forbidden'); }

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="partner_daily_template.csv"');

$out = fopen('php://output', 'w');
// Required columns
fputcsv($out, ['date','driver uuid','driver name','total orders','total amount']);

// Example rows
$today = date('Y-m-d');
fputcsv($out, [$today, 'TB0001', 'Sample Driver', '18', '52.500']);
fputcsv($out, [$today, 'AK0003', 'Another Driver', '12', '34.750']);
fclose($out);
exit;
