<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
$role = get_current_role();
if (!can_view_lookups($role)) { http_response_code(403); exit('Forbidden'); }
$resources = ['projects'=>'Projects','cities'=>'Cities'];
$active = $_GET['r'] ?? 'projects'; if (!array_key_exists($active,$resources)) $active='projects';
$canManage = can_manage_lookups($role);
if ($canManage && ($_POST['action'] ?? '')==='create') { $name=trim($_POST['name']??''); if($name!==''){ $s=$conn->prepare("INSERT INTO $active(name) VALUES (?)"); $s->bind_param('s',$name); $s->execute(); } }
$res = $conn->query("SELECT id,name FROM $active ORDER BY name")->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<title>Lookups - Hisbuu</title></head>
<body class="bg-light">
<div class="container py-4">
  <a href="/hisbuu/public/dashboard.php" class="btn btn-outline-secondary btn-sm mb-3">Back</a>
  <div class="row">
    <div class="col-md-3">
      <div class="list-group">
        <?php foreach ($resources as $k=>$v): ?>
          <a class="list-group-item <?php echo $active===$k?'active':''; ?>" href="?r=<?php echo $k; ?>"><?php echo e($v); ?></a>
        <?php endforeach; ?>
      </div>
    </div>
    <div class="col-md-9">
      <div class="card"><div class="card-body">
        <h6 class="mb-3"><?php echo e($resources[$active]); ?></h6>
        <?php if ($canManage): ?>
        <form class="row g-2 mb-3" method="POST">
          <input type="hidden" name="action" value="create">
          <div class="col"><input class="form-control" name="name" placeholder="New name" required></div>
          <div class="col-auto"><button class="btn btn-danger">Add</button></div>
        </form>
        <?php endif; ?>
        <table class="table table-sm"><thead><tr><th>ID</th><th>Name</th></tr></thead>
          <tbody><?php foreach ($res as $r): ?><tr><td><?php echo (int)$r['id']; ?></td><td><?php echo e($r['name']); ?></td></tr><?php endforeach; ?></tbody>
        </table>
      </div></div>
    </div>
  </div>
</div>
</body></html>
