<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_manage_partner_daily(get_current_role())) { http_response_code(403); exit('Forbidden'); }
$action = $_POST['action'] ?? '';
if ($action==='create'){
  $service_date = $_POST['service_date'] ?? '';
  $project_id = (int)($_POST['project_id'] ?? 0);
  $total_orders = (int)($_POST['total_orders'] ?? 0);
  $total_amount = isset($_POST['total_amount']) ? round((float)$_POST['total_amount'],3) : 0.000;
  $p = $conn->prepare('SELECT name FROM projects WHERE id=?'); $p->bind_param('i',$project_id); $p->execute(); $row=$p->get_result()->fetch_assoc();
  if(!$row){ exit('Invalid partner'); }
  $partner_name = $row['name'];
  $stmt = $conn->prepare('INSERT INTO partner_daily(service_date,project_id,partner_name,total_orders,total_amount) VALUES (?,?,?,?,?) ON DUPLICATE KEY UPDATE partner_name=VALUES(partner_name), total_orders=VALUES(total_orders), total_amount=VALUES(total_amount)');
  $stmt->bind_param('sisis',$service_date,$project_id,$partner_name,$total_orders,$total_amount); // last param treated as string ok for MySQL; alternatively use 'sidid' and cast double
  $stmt->execute();
  $q=$conn->prepare('SELECT id FROM partner_daily WHERE service_date=? AND project_id=?'); $q->bind_param('si',$service_date,$project_id); $q->execute(); $id=($q->get_result()->fetch_assoc())['id']??0;
  $_POST=['action'=>'recalc','id'=>$id];
}
if ($action==='recalc'){
  $id = (int)($_POST['id'] ?? 0);
  $row = $conn->prepare('SELECT service_date, project_id FROM partner_daily WHERE id=?'); $row->bind_param('i',$id); $row->execute(); $pd=$row->get_result()->fetch_assoc();
  if($pd){
    $sum = $conn->prepare('SELECT COALESCE(SUM(s.orders_count),0) so, COALESCE(SUM(s.cash_deposited),0) sc FROM submissions s JOIN drivers d ON d.id=s.driver_id WHERE d.project_id=? AND s.service_date=?');
    $sum->bind_param('is',$pd['project_id'],$pd['service_date']); $sum->execute(); $agg=$sum->get_result()->fetch_assoc();
    $mo=(int)($agg['so']??0); $ma=(float)($agg['sc']??0);
    $st = ($mo>0 || $ma>0) ? 'awaiting_approval' : 'yet_to_pay';
    $upd=$conn->prepare('UPDATE partner_daily SET matched_orders=?, matched_amount=?, status=? WHERE id=?'); $upd->bind_param('idsi',$mo,$ma,$st,$id); $upd->execute();
  }
  header('Location: data_entry.php?month='.date('Y-m', strtotime($pd['service_date']))); exit;
}
header('Location: data_entry.php');