<?php
// public/admin/cities_manage.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';

$role        = get_current_role();
$can_view    = function_exists('can_view_lookups')   ? can_view_lookups($role)   : in_array($role, ['Supervisor','Administrator','Super Administrator'], true);
$can_manage  = function_exists('can_manage_lookups') ? can_manage_lookups($role) : in_array($role, ['Administrator','Super Administrator'], true);

if (!$can_view) { http_response_code(403); exit('Forbidden'); }

// CSRF
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

// Helpers
function table_exists_fast(mysqli $c, $name) {
  $name = $c->real_escape_string($name);
  $res  = $c->query("SHOW TABLES LIKE '$name'");
  return $res && $res->num_rows > 0;
}
function column_exists(mysqli $c, $table, $col) {
  $db = $c->query("SELECT DATABASE() AS d")->fetch_assoc()['d'] ?? '';
  if ($db === '') return false;
  $t = $c->real_escape_string($table);
  $k = $c->real_escape_string($col);
  $sql = "SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='$db' AND TABLE_NAME='$t' AND COLUMN_NAME='$k' LIMIT 1";
  $r = $c->query($sql);
  return $r && $r->num_rows > 0;
}
if (!table_exists_fast($conn, 'cities')) { http_response_code(500); exit('Missing table: cities'); }

// Column capabilities
$has_is_active  = column_exists($conn, 'cities', 'is_active');
$has_updated_at = column_exists($conn, 'cities', 'updated_at');

// Supervisors are view-only, block any writes and edit/new/delete routes
if (!$can_manage) {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') { http_response_code(403); exit('Forbidden'); }
  if (isset($_GET['new']) || isset($_GET['edit']) || isset($_POST['delete_id']) || isset($_POST['action'])) {
    http_response_code(403); exit('Forbidden');
  }
}

$err=''; $ok='';

// Managers may create/update/delete using only available columns
if ($can_manage && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $action = $_POST['action'] ?? '';

  if ($action === 'create') {
    $name = trim($_POST['name'] ?? '');
    if ($name === '') { $err = 'Name is required.'; }
    else {
      if ($has_is_active) {
        $st = $conn->prepare("INSERT INTO cities(name, is_active".($has_updated_at?", updated_at":"").") VALUES (?, 1".($has_updated_at?", NOW()":"").")");
        $st->bind_param('s', $name);
      } else {
        $st = $conn->prepare("INSERT INTO cities(name".($has_updated_at?", updated_at":"").") VALUES (?".($has_updated_at?", NOW()":"").")");
        $st->bind_param('s', $name);
      }
      $ok = $st->execute() ? 'Created.' : 'Create failed.';
    }
  }

  if ($action === 'update') {
    $id   = isset($_POST['id']) && ctype_digit($_POST['id']) ? (int)$_POST['id'] : 0;
    $name = trim($_POST['name'] ?? '');
    $act  = $has_is_active ? (isset($_POST['is_active']) ? 1 : 0) : null;

    if ($id <= 0) { $err = 'Invalid ID.'; }
    elseif ($name === '') { $err = 'Name is required.'; }
    else {
      if ($has_is_active) {
        $st = $conn->prepare("UPDATE cities SET name=?, is_active=?".($has_updated_at?", updated_at=NOW()":"")." WHERE id=?");
        $st->bind_param('sii', $name, $act, $id);
      } else {
        $st = $conn->prepare("UPDATE cities SET name=?".($has_updated_at?", updated_at=NOW()":"")." WHERE id=?");
        $st->bind_param('si', $name, $id);
      }
      $ok = $st->execute() ? 'Updated.' : 'Update failed.';
    }
  }

  if ($action === 'delete') {
    $id = isset($_POST['id']) && ctype_digit($_POST['id']) ? (int)$_POST['id'] : 0;
    if ($id <= 0) { $err = 'Invalid ID.'; }
    else {
      $st = $conn->prepare("DELETE FROM cities WHERE id=?");
      $st->bind_param('i', $id);
      $ok = $st->execute() ? 'Deleted.' : 'Delete failed.';
    }
  }
}

// Edit/New flags for managers only
$edit_id  = ($can_manage && isset($_GET['edit']) && ctype_digit($_GET['edit'])) ? (int)$_GET['edit'] : 0;
$new_mode = ($can_manage && isset($_GET['new']));

// Load list, only select columns that exist
$cols = ['id','name'];
if ($has_is_active)  $cols[] = 'is_active';
if ($has_updated_at) $cols[] = 'updated_at';
$select = implode(',', $cols);

$rs   = $conn->query("SELECT $select FROM cities ORDER BY name ASC");
$rows = $rs ? $rs->fetch_all(MYSQLI_ASSOC) : [];

// If editing, fetch record
$rec = null;
if ($edit_id > 0) {
  $st = $conn->prepare("SELECT $select FROM cities WHERE id=?");
  $st->bind_param('i', $edit_id);
  $st->execute();
  $rec = $st->get_result()->fetch_assoc();
  if (!$rec) $edit_id = 0;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Cities | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-4" style="max-width:1000px;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Cities</h5>
    <?php if ($can_manage): ?>
      <a href="?new=1" class="btn btn-danger btn-sm">Add new</a>
    <?php endif; ?>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><?php echo e($err); ?></div><?php endif; ?>
  <?php if ($ok):  ?><div class="alert alert-success"><?php echo e($ok);  ?></div><?php endif; ?>

  <?php if ($new_mode): ?>
    <div class="card mb-3"><div class="card-body">
      <h6 class="mb-3">Create city</h6>
      <form method="post" class="row g-3">
        <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
        <input type="hidden" name="action" value="create">
        <div class="col-md-6">
          <label class="form-label">Name</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <?php if ($has_is_active): ?>
        <div class="col-md-3">
          <div class="form-check mt-4">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active_new" checked>
            <label class="form-check-label" for="is_active_new">Active</label>
          </div>
        </div>
        <?php endif; ?>
        <div class="col-12 text-end">
          <a href="cities_manage.php" class="btn btn-outline-secondary">Cancel</a>
          <button class="btn btn-danger">Create</button>
        </div>
      </form>
    </div></div>
  <?php endif; ?>

  <?php if ($edit_id > 0 && $rec): ?>
    <div class="card mb-3"><div class="card-body">
      <h6 class="mb-3">Edit city</h6>
      <form method="post" class="row g-3">
        <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
        <input type="hidden" name="action" value="update">
        <input type="hidden" name="id" value="<?php echo (int)$rec['id']; ?>">

        <div class="col-md-6">
          <label class="form-label">Name</label>
          <input type="text" name="name" class="form-control" value="<?php echo e($rec['name']); ?>" required>
        </div>

        <?php if ($has_is_active): ?>
        <div class="col-md-3">
          <div class="form-check mt-4">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?php echo ((int)($rec['is_active'] ?? 1)===1)?'checked':''; ?>>
            <label class="form-check-label" for="is_active">Active</label>
          </div>
        </div>
        <?php endif; ?>

        <div class="col-12 text-end">
          <a href="cities_manage.php" class="btn btn-outline-secondary">Cancel</a>
          <button class="btn btn-danger">Save</button>
        </div>
      </form>
    </div></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-sm table-striped align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th>Name</th>
              <?php if ($has_is_active): ?><th>Status</th><?php endif; ?>
              <?php if ($has_updated_at): ?><th class="text-nowrap">Updated</th><?php endif; ?>
              <?php if ($can_manage): ?><th class="text-end">Action</th><?php endif; ?>
            </tr>
          </thead>
          <tbody>
          <?php if (!$rows): ?>
            <tr>
              <td colspan="<?php echo ($can_manage?1:0) + ($has_is_active?1:0) + ($has_updated_at?1:0) + 1; ?>" class="text-muted">No records.</td>
            </tr>
          <?php else: foreach ($rows as $r): ?>
            <tr>
              <td><?php echo e($r['name']); ?></td>
              <?php if ($has_is_active): ?>
                <td>
                  <?php if ((int)($r['is_active'] ?? 1) === 1): ?>
                    <span class="badge text-bg-success">Active</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">Inactive</span>
                  <?php endif; ?>
                </td>
              <?php endif; ?>
              <?php if ($has_updated_at): ?>
                <td class="text-nowrap"><?php echo e($r['updated_at']); ?></td>
              <?php endif; ?>

              <?php if ($can_manage): ?>
              <td class="text-end">
                <a href="?edit=<?php echo (int)$r['id']; ?>" class="btn btn-outline-primary btn-sm">Edit</a>
                <form method="post" class="d-inline" onsubmit="return confirm('Delete this item?');">
                  <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
                  <input type="hidden" name="action" value="delete">
                  <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
                  <button class="btn btn-outline-danger btn-sm">Delete</button>
                </form>
              </td>
              <?php endif; ?>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
