<?php
// includes/time.php
require_once __DIR__ . '/settings.php'; // load settings helper before using app_setting

function set_app_timezone(?mysqli $conn = null): void {
    $tz = app_setting('app.timezone', 'Asia/Muscat', $conn);
    if (!in_array($tz, DateTimeZone::listIdentifiers(), true)) {
        $tz = 'Asia/Muscat';
    }

    date_default_timezone_set($tz);

    if ($conn instanceof mysqli) {
        try {
            @$conn->query("SET time_zone = '".$conn->real_escape_string($tz)."'");
            if ($conn->errno) {
                $conn->query("SET time_zone = '+04:00'");
            }
        } catch (Throwable $e) {
            @$conn->query("SET time_zone = '+04:00'");
        }
    }
}

/**
 * Get today's date as DateTime object (local timezone)
 *
 * @return DateTime Today's date
 */
function today_local(): DateTime {
    return new DateTime('today');
}

/**
 * Get yesterday's date as DateTime object (local timezone)
 *
 * @return DateTime Yesterday's date
 */
function yesterday_local(): DateTime {
    return (new DateTime('today'))->modify('-1 day');
}
