<?php
/**
 * session_config.php
 * Centralized session configuration for secure session handling
 * 
 * This file should be included before any session_start() calls
 * to ensure consistent and secure session configuration across the application.
 */

// Prevent direct access
if (!defined('HISBUU_LOADED')) {
    define('HISBUU_LOADED', true);
}

// If a session is already active (or sessions are disabled), we can't change ini/cookie params.
// This file is safe to include multiple times across the app.
$sessionStatus = session_status();
if ($sessionStatus !== PHP_SESSION_NONE) {
    return;
}

// Configure session cookie parameters
// Check if HTTPS is enabled
$httpsEnabled = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
    || $_SERVER['SERVER_PORT'] == 443;

$cookieParams = [
    'lifetime' => 1800,  // 30 minutes session timeout
    'path' => '/',
    'domain' => '',       // Will use current domain
    'secure' => $httpsEnabled,    // Automatically detect HTTPS
    'httponly' => true,  // Prevent JavaScript access to session cookie
    'samesite' => 'Lax'  // Lax SameSite policy - allows same-site subresource requests (images, etc)
];

// Set session cookie parameters
if (!headers_sent()) {
    session_set_cookie_params($cookieParams);
}

// Configure session settings
ini_set('session.use_strict_mode', '1');          // Prevent session fixation
ini_set('session.cookie_httponly', '1');          // Prevent JavaScript access
ini_set('session.cookie_secure', $httpsEnabled ? '1' : '0');  // Automatically detect HTTPS
ini_set('session.cookie_samesite', 'Lax');         // Lax SameSite policy - allows same-site subresource requests
ini_set('session.use_only_cookies', '1');          // Only use cookies for session ID
ini_set('session.gc_maxlifetime', '1800');         // 30 minutes garbage collection
ini_set('session.gc_probability', '1');            // Probability of garbage collection
ini_set('session.gc_divisor', '100');             // 1% chance of garbage collection

// Set session name (optional, helps identify session cookie)
if (!headers_sent()) {
    session_name('HISBUU_SESSION');
}

// Note: session_start() should be called after including this file
// Example:
// require_once __DIR__ . '/session_config.php';
// if (session_status() === PHP_SESSION_NONE) session_start();
