<?php
require_once __DIR__ . '/driver_auth.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/settings.php';
require_once __DIR__ . '/../config/db.php';

// 1. Auth Check
// We rely on driver_auth.php to handle redirects (Login only).
require_driver_login();

// 2. Verified flag (KYC disabled for now, treat all as verified)
$is_verified = true;

// 3. Branding
$appName = app_setting('branding.app_name', 'Hisbuu');
$driverLogo = app_setting('branding.driver_logo', '');
if ($driverLogo !== '' && strpos($driverLogo, 'storage/') === 0) {
    $driverLogo = file_url($driverLogo);
}

/*
  Active state helper
*/
$currentPage = basename($_SERVER['SCRIPT_NAME']);

function driver_nav_is_active($pages) {
    global $currentPage;
    return in_array($currentPage, $pages) ? ' active' : '';
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo isset($title) ? e($title) : 'Driver Portal'; ?> - <?php echo e($appName); ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
<link rel="manifest" href="manifest.json">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<link rel="apple-touch-icon" href="icons/icon-192.png">

<meta name="theme-color" content="#dc3545">

<style>
:root {
    --red: #dc3545;
    --red-soft: #fee2e2;
    --nav-shadow: 0 -1px 4px rgba(0,0,0,0.08);
}

body {
    background: #f8fafc;
    /* LOGIC FIX: Only add padding if the bottom nav is actually visible */
    padding-bottom: <?php echo $is_verified ? '70px' : '0'; ?>;
}

/* TOP BAR */
.driver-topbar {
    position: sticky;
    top: 0;
    z-index: 2000;
    background: #ffffff;
    box-shadow: 0 1px 4px rgba(0,0,0,0.08);
}
.driver-topbar-inner {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 14px;
    max-width: 900px;
    margin: auto;
}
.driver-logo {
    display: flex;
    align-items: center;
    gap: 8px;
}
.driver-logo-circle {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: var(--red-soft);
    display: flex;
    justify-content: center;
    align-items: center;
    color: var(--red);
    font-weight: bold;
}
.driver-title {
    font-weight: 600;
    color: var(--red);
    font-size: 16px;
}
.driver-sub {
    font-size: 11px;
    color: #6b7280;
}
.driver-right {
    display: flex;
    align-items: center;
    gap: 10px;
}
.driver-partner {
    background: #f3f4f6;
    padding: 4px 9px;
    border-radius: 999px;
    font-size: 12px;
    max-width: 120px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.menu-btn {
    background: none;
    border: none;
    font-size: 20px;
}

/* BOTTOM NAVIGATION */
.driver-bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0; right: 0;
    background: #ffffff;
    box-shadow: var(--nav-shadow);
    z-index: 2000;
}
.driver-bottom-inner {
    display: flex;
    justify-content: space-around;
    padding: 5px 0;
    max-width: 480px;
    margin: auto;
}
.nav-item {
    flex: 1;
    text-align: center;
    padding: 4px 0;
    color: #6b7280;
    font-size: 12px;
}
.nav-item i {
    display: block;
    font-size: 18px;
}
.nav-item.active {
    color: var(--red);
    font-weight: 600;
}

/* DRAWER */
.drawer-backdrop {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.45);
    opacity: 0;
    transition: .2s;
    pointer-events: none;
    z-index: 1999;
}
.drawer {
    position: fixed;
    top: 0;
    right: -260px;
    width: 260px;
    height: 100%;
    background: #fff;
    box-shadow: -2px 0 8px rgba(0,0,0,0.25);
    z-index: 2001;
    transition: .25s;
}
body.drawer-open .drawer {
    right: 0;
}
body.drawer-open .drawer-backdrop {
    opacity: 1;
    pointer-events: auto;
}
.drawer-header {
    padding: 10px 14px;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    font-weight: 600;
}
.drawer-menu a {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 14px;
    color: #333;
    text-decoration: none;
}
.drawer-menu a.active {
    background: var(--red-soft);
    color: var(--red);
    font-weight: 600;
}
.drawer-footer {
    padding: 10px 14px;
    font-size: 11px;
    color: #888;
    border-top: 1px solid #eee;
}

/* Remove underline from bottom nav */
.nav-item, .nav-item:visited, .nav-item i {
    text-decoration: none !important;
}

/* Colors and shadows */
:root {
    --red: #dc3545;
    --red-soft: #fee2e2;
    --nav-shadow: 0 -1px 4px rgba(0,0,0,0.08);
}
.driver-content {
  padding-top: 10px; /* ensures content never hides under the top bar */
  max-width: 900px;
}
/* Mobile App Style Preloader */
#preloader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: #ffffff;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 2000;
}

.loader {
  width: 40px;
  height: 40px;
  border: 4px solid #f3f3f3;
  border-top: 4px solid #dc3545;
  border-radius: 50%;
  animation: spin 0.7s linear infinite;
}

@keyframes spin {
  to { transform: rotate(360deg); }
}

/* ============================
   SAFE AREA + MODAL FIXES
   ============================ */

/* Ensure modal stays inside safe area (iOS notch, Android cutouts) */
@supports(padding: max(0px)) {
  .modal-dialog {
    padding-top: env(safe-area-inset-top);
    padding-bottom: env(safe-area-inset-bottom);
  }
}

/* Center modal and keep it inside viewport */
.modal-dialog {
  max-width: 95%;
  margin: 0 auto;
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
}

/* Prevent modal from going under top bar + bottom nav */
.modal-content {
  height: calc(100vh - 140px);        /* 140px = approximate safe area + nav bars */
  max-height: calc(100vh - 140px);
  display: flex;
  flex-direction: column;
  border-radius: 12px;
  overflow: hidden;                   /* Prevent spill */
}

/* Header & footer never scroll */
.modal-header,
.modal-footer {
  flex-shrink: 0;
}

/* Body scrolls only; smooth touch scrolling */
.modal-body {
  flex: 1;
  overflow-y: auto;
  -webkit-overflow-scrolling: touch;
  padding: 1rem;
}

/* Tabs stay readable on mobile */
#fileTabs .nav-link {
  white-space: nowrap;
  font-size: 13px;
}

/* ============================
   IMAGE & IFRAMES
   ============================ */

/* Make images responsive and contained */
.file-preview-img,
#filesModal img {
  max-width: 100%;
  height: auto;
  max-height: calc(100vh - 240px);
  object-fit: contain;
  border-radius: 6px;
  display: block;
  margin: 0 auto;
}

/* Proper iframe embedding */
.file-preview-frame,
#filesModal iframe {
  width: 100% !important;
  height: calc(100vh - 240px) !important;
  border: none;
  border-radius: 6px;
}

/* Prevent background scroll when modal is open */
body.modal-open {
  overflow: hidden;
  padding-right: 0 !important;
}

.pwa-update-bar {
  position: fixed;
  left: 50%;
  transform: translateX(-50%);
  bottom: 60px; /* above bottom nav */
  background: #0f172a;
  color: #ffffff;
  padding: 6px 12px;
  border-radius: 999px;
  font-size: 12px;
  display: none;
  align-items: center;
  gap: 8px;
  z-index: 2100;
}

.pwa-update-bar button {
  border: none;
  border-radius: 999px;
  padding: 4px 10px;
  font-size: 11px;
  background: #f97316;
  color: #ffffff;
}

#pwa-update-bar {
  position: fixed;
  bottom: 65px; /* above bottom nav */
  left: 50%;
  transform: translateX(-50%);
  z-index: 5000;
}

/* ------------------------------------------
   OPTIMIZED MOBILE SCROLL & PULL FEEL
   ------------------------------------------ */

/* Smoother vertical scroll, reduces stiffness on Android */
html, body {
    overscroll-behavior-y: auto;       /* allow pull to refresh but avoid chaos */
    -webkit-overflow-scrolling: touch; /* smoother inertial scrolling */
    scroll-behavior: smooth;
}

/* Prevent stutter when closing drawer or modal */
body.drawer-open,
body.modal-open {
    overscroll-behavior-y: none; /* disable TPS pull fight */
}

/* Reduce bounce behind sticky top bar */
.driver-topbar {
    background-color: #fff;
    contain: layout paint style; /* isolates repaint zone */
    will-change: transform;     /* ensures smoothness */
}

/* Prevent bottom bar from jiggling during overscroll */
.driver-bottom-nav {
    background-color: #fff;
}

/* Improve scroll inside collapsible sections */
.accordion .collapse {
    -webkit-overflow-scrolling: touch;
}

/* Prevent harsh glow on pull */
body {
    background-color: #fafafa; /* softer backdrop reduces glow contrast */
}

/* Soften the momentum and friction feel */
* {
    touch-action: pan-y; /* restrict diagonal accidental gestures */
}

/* Improve performance on low end devices */
* {
    backface-visibility: hidden;
}


</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
  setTimeout(function() {
    document.getElementById('preloader').style.opacity = '0';
    setTimeout(function() {
      document.getElementById('preloader').style.display = 'none';
    }, 300);
  }, 400); // small delay for mobile feel
});
</script>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const openBtn = document.querySelectorAll("[data-drawer-open]");
    const closeBtn = document.querySelectorAll("[data-drawer-close]");
    const backdrop = document.getElementById("drawerBackdrop");

    function openDrawer() {
        document.body.classList.add("drawer-open");
    }
    function closeDrawer() {
        document.body.classList.remove("drawer-open");
    }

    openBtn.forEach(b => b.onclick = openDrawer);
    closeBtn.forEach(b => b.onclick = closeDrawer);
    if (backdrop) backdrop.onclick = closeDrawer;
});
</script>
<script>
// Simple PWA event logger (optional backend)
// Safe if pwa_event_logger.php does not exist
function logPwaEvent(type, details) {
  try {
    fetch('<?php echo base_url('driver/pwa_event_logger.php'); ?>', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({
        type: type,
        details: details || {},
        ts: Date.now()
      })
    }).catch(function () {});
  } catch (e) {}
}

let deferredInstallPrompt = null;
let newWorkerForUpdate = null;

if ('serviceWorker' in navigator) {
  window.addEventListener('load', function () {
    navigator.serviceWorker
      .register('driver-sw.js', { scope: './' })
      .then(function (reg) {
        // Watch for new versions
        reg.addEventListener('updatefound', function () {
          const installing = reg.installing;
          if (!installing) return;

          installing.addEventListener('statechange', function () {
            if (
              installing.state === 'installed' &&
              navigator.serviceWorker.controller
            ) {
              // New version ready
              newWorkerForUpdate = installing;
              var bar = document.getElementById('pwa-update-bar');
              if (bar) {
                bar.style.display = 'flex';
              }
              logPwaEvent('sw_update_found', {});
            }
          });
        });

        // If there is already a waiting worker, show update bar
        if (reg.waiting && navigator.serviceWorker.controller) {
          newWorkerForUpdate = reg.waiting;
          var bar = document.getElementById('pwa-update-bar');
          if (bar) {
            bar.style.display = 'flex';
          }
        }
      })
      .catch(function (err) {
        console.warn('Driver SW registration failed:', err);
      });
  });

  // When controller changes after skipWaiting, reload once
  let hasReloadedForSW = false;
  navigator.serviceWorker.addEventListener('controllerchange', function () {
    if (hasReloadedForSW) return;
    hasReloadedForSW = true;
    window.location.reload();
  });
}

// Strict offline lock
document.addEventListener('DOMContentLoaded', function () {
  function goOfflineLock() {
    if (window.location.pathname.indexOf('offline.html') === -1) {
      window.location.href = 'offline.html';
    }
  }

  if (!navigator.onLine) {
    goOfflineLock();
    return;
  }

  window.addEventListener('offline', function () {
    goOfflineLock();
  });
});

// PWA install handling
document.addEventListener('DOMContentLoaded', function () {
  var installBtn = document.getElementById('pwa-install-btn');

  window.addEventListener('beforeinstallprompt', function (e) {
    e.preventDefault();
    deferredInstallPrompt = e;
    if (installBtn) {
      installBtn.style.display = 'flex';
    }
    logPwaEvent('beforeinstallprompt', {});
  });

  if (installBtn) {
    installBtn.addEventListener('click', function (e) {
      e.preventDefault();
      if (!deferredInstallPrompt) {
        return;
      }

      deferredInstallPrompt.prompt();
      deferredInstallPrompt.userChoice.then(function (choiceResult) {
        logPwaEvent('install_choice', { outcome: choiceResult.outcome });
        if (choiceResult.outcome === 'accepted') {
          installBtn.style.display = 'none';
        }
        deferredInstallPrompt = null;
      });
    });
  }

  window.addEventListener('appinstalled', function () {
    logPwaEvent('appinstalled', {});
    if (installBtn) {
      installBtn.style.display = 'none';
    }
  });

  // Update bar button
  var updateBar = document.getElementById('pwa-update-bar');
  var updateBtn = document.getElementById('pwa-update-btn');

  if (updateBtn) {
    updateBtn.addEventListener('click', function () {
      if (newWorkerForUpdate) {
        newWorkerForUpdate.postMessage({ type: 'SKIP_WAITING' });
        logPwaEvent('update_confirmed', {});
      } else {
        if (updateBar) updateBar.style.display = 'none';
      }
    });
  }
});
</script>


</head>
<body>
<div id="preloader">
  <div class="loader"></div>
</div>
<div id="pwa-update-bar" class="pwa-update-bar">
  <span>New version of <?php echo e($appName); ?> Driver is ready.</span>
  <button type="button" id="pwa-update-btn">Update</button>
</div>

<header class="driver-topbar">
  <div class="driver-topbar-inner">
      <div class="driver-logo">
          <?php if ($driverLogo): ?>
            <img src="<?php echo e($driverLogo); ?>" alt="<?php echo e($appName); ?>" style="max-height:36px;max-width:140px;object-fit:contain;">
          <?php else: ?>
            <div class="driver-logo-circle"><?php echo e(substr($appName, 0, 1)); ?></div>
            <div>
                <div class="driver-title"><?php echo e($appName); ?> Driver</div>
                <div class="driver-sub">Driver portal</div>
            </div>
          <?php endif; ?>
      </div>

      <div class="driver-right">
          <?php if (!empty($_SESSION['driver']['partner_id'])): ?>
              <div class="driver-partner"><?php echo e($_SESSION['driver']['partner_id']); ?></div>
          <?php endif; ?>

          <button class="menu-btn" data-drawer-open><i class="bi bi-list"></i></button>
      </div>
  </div>
</header>


<nav class="driver-bottom-nav">
  <div class="driver-bottom-inner">
      <a class="nav-item<?php echo driver_nav_is_active(['dashboard.php']); ?>" href="dashboard.php">
          <i class="bi bi-house"></i> Home
      </a>
      <a class="nav-item<?php echo driver_nav_is_active(['my_submissions.php']); ?>" href="my_submissions.php">
          <i class="bi bi-inbox"></i> Submissions
      </a>
      <a class="nav-item<?php echo driver_nav_is_active(['adjustments.php']); ?>" href="adjustments.php">
          <i class="bi bi-sliders"></i> Adjustments
      </a>
      <a class="nav-item<?php echo driver_nav_is_active(['payouts_list.php','payout_view.php']); ?>" href="payouts_list.php">
          <i class="bi bi-wallet2"></i> Payouts
      </a>
      <a class="nav-item" data-drawer-open>
          <i class="bi bi-three-dots"></i> More
      </a>
  </div>
</nav>

<div class="drawer-backdrop" id="drawerBackdrop"></div>

<aside class="drawer">
  <div class="drawer-header">
      <span>Menu</span>
      <button class="menu-btn" data-drawer-close><i class="bi bi-x-lg"></i></button>
  </div>

  <div class="drawer-menu">
      <a href="dashboard.php" class="<?php echo driver_nav_is_active(['dashboard.php']); ?>">
          <i class="bi bi-speedometer2"></i> Dashboard
      </a>

      <a href="my_submissions.php" class="<?php echo driver_nav_is_active(['my_submissions.php']); ?>">
          <i class="bi bi-inbox"></i> Submissions
      </a>

      <a href="history.php" class="<?php echo driver_nav_is_active(['history.php']); ?>">
          <i class="bi bi-clock-history"></i> History
      </a>

      <a href="reports.php" class="<?php echo driver_nav_is_active(['reports.php']); ?>">
          <i class="bi bi-graph-up"></i> Reports
      </a>

      <a href="adjustments.php" class="<?php echo driver_nav_is_active(['adjustments.php']); ?>">
          <i class="bi bi-sliders"></i> Adjustments
      </a>

      <a href="payouts_list.php" class="<?php echo driver_nav_is_active(['payouts_list.php','payout_view.php']); ?>">
          <i class="bi bi-wallet2"></i> Payouts
      </a>

      <a href="kyd_manage.php" class="<?php echo driver_nav_is_active(['kyd_manage.php']); ?>">
          <i class="bi bi-folder2-open"></i> Documents
      </a>
 
      <a href="my_gear.php" class="<?php echo driver_nav_is_active(['my_gear.php']); ?>">
          <i class="bi bi-box-seam"></i> Gears & Inventories
      </a>

      <a href="#" id="pwa-install-btn" style="display:none;">
          <i class="bi bi-download"></i> Install Hisbuu Driver
      </a>

      <a href="logout.php">
          <i class="bi bi-box-arrow-right"></i> Logout
      </a>
  </div>

  <div class="drawer-footer">
      Logged in as Driver ID <?php echo (int)($_SESSION['driver']['id']); ?>
  </div>
</aside>

<div class="driver-content container mb-4">
