<?php
// includes/driver_auth_check.php
// Driver authentication check - ensures driver is logged in before accessing protected resources

require_once __DIR__ . '/session_config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function require_driver_login(): void {
    if (!driver_logged_in()) {
        header('Location: login.php', true, 302);
        exit;
    }
}

function current_driver_id(): int {
    return (int)($_SESSION['driver']['id'] ?? 0);
}

function driver_logged_in(): bool {
    return isset($_SESSION['driver']) && !empty($_SESSION['driver']['id']);
}
