<?php
// /hisbuu/includes/auth_check.php
require_once __DIR__ . '/session_config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

function require_login(): void {
  if (!is_logged_in()) {
    $inAdmin = strpos($_SERVER['SCRIPT_NAME'], '/admin/') !== false;
    $path = $inAdmin ? 'login.php' : 'admin/login.php';
    header('Location: ' . $path, true, 302);
    exit;
  }
}

function is_logged_in(): bool {
  return isset($_SESSION['user']) && !empty($_SESSION['user']['id']);
}

function redirect_if_logged_in(): void {
  if (is_logged_in()) {
    header('Location: ../dashboard.php', true, 302);
    exit;
  }
}

function current_user_id(): int {
  return (int)($_SESSION['user']['id'] ?? 0);
}

function current_user_role(): string {
  return (string)($_SESSION['user']['role'] ?? '');
}

function logout_user(): void {
  if (session_status() === PHP_SESSION_NONE) session_start();
  unset($_SESSION['user']);
  session_regenerate_id(true);
}
