<?php
// config/db.php
// Load environment variables from .env file
$envFile = __DIR__ . '/../.env';
if (is_file($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        // Skip comments
        if (strpos(trim($line), '#') === 0) {
            continue;
        }
        // Parse key=value pairs
        if (strpos($line, '=') !== false) {
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);
            // Remove quotes if present
            $value = trim($value, '"\'');
            // Set as environment variable
            if (!array_key_exists($key, $_ENV)) {
                $_ENV[$key] = $value;
                putenv("$key=$value");
            }
        }
    }
}

// Database configuration from environment variables
$DB_HOST = getenv('DB_HOST') ?: 'localhost';
$DB_PORT = (int)(getenv('DB_PORT') ?: 3307);
$DB_NAME = getenv('DB_NAME') ?: 'hisub_om';
$DB_USER = getenv('DB_USER') ?: 'root';
$DB_PASS = getenv('DB_PASS') ?: '';

require_once __DIR__ . '/../includes/time.php';

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME, $DB_PORT);
if ($conn->connect_error) {
  // Log error instead of displaying to user
  error_log('DB connection failed: ' . $conn->connect_error);
  die('Database connection error. Please contact support.');
}

// lock both PHP and this MySQL session to Asia/Muscat
set_app_timezone($conn);

